// Prijimac

#include "main.h"
#include "..\common.h"

#DEFINE  LCD_RS          PIN_B1      // rizeni registru LCD displeje
#DEFINE  LCD_E           PIN_B0      // enable LCD displeje
#DEFINE  LCD_DATA_LSB    PIN_B2      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"

#DEFINE  PRIJIMAC        PIN_A3      // pin na ktery je pripojen prijimac
#DEFINE  SERVO_X         PIN_A0      // pin na ktery je pripojeno servo
#DEFINE  SERVO_Y         PIN_A1


int8 prijmout(int8* bit)
{
// ||    |
// |--|_____   1
//       |
// |-|__|-|_   0

   while (!input(PRIJIMAC)) ;                // cekej na jednicku
   delay_us(IMPULS/4);                       // presvec se, jestli je stale 1 po 1/4 impulsu
   if (!input(PRIJIMAC)) return false;       // vrat chybu, kdyz neni stale 1
   delay_us(3*IMPULS);                       // pockej na rozhodovaci misto
///   if (input(PRIJIMAC)) *bit=0; else *bit=1; // dekoduj 1 nebo 0
   *bit=!input(PRIJIMAC);                    // dekoduj 1 nebo 0
   delay_us(IMPULS);                         // pockej na konec znaku

   return true;                                // vrat, ze se cteni povedlo
}

int8 read_nibble(int8* data)
{
   int8 i;
   int8 d;

   d=0;

   // Cekam na dlouhou nulu
   for (i=8; i>0; i--)
   {
      if (input(PRIJIMAC)) i=8;
      delay_us(IMPULS/2);
   }

   // Cekam na jednicku (start ramce)
   for (; !input(PRIJIMAC); )
   {
      delay_us(IMPULS/2);
   }

   delay_us(IMPULS/2);

   // Prenasim bity
   for (i=0; i<4; i++)
   {
      delay_us(2*IMPULS);
      d >>= 1;
      if (!input(PRIJIMAC)) d +=8;
   }
   *data = d;
   return TRUE;
}

int8 read_nibble2(int8* value)
{
   int8 n;     // citac
   int8 bit;   // pomocna promenna

   *value=0;
   for (n=1; n<=4; n++)                      // prijmi 4 bity
   {
      *value >>= 1;                          // posun jiz prectene do leva
      if (0==prijmout(&bit)) return(false);      // prijmi bit; pri chybe cteni vrat chybu
      *value |= bit << 3;                    // pridej bit do nibblu
   };
   return(true);                                // vrat 1, jako ,ze je vse O.K.
}


int8     bit,x,y;
int8 xc,yc;          // pocitadla aktualizace x a y

void main()
{
   lcd_init();                  // zinicializuj LCD display
   delay_ms(5);
   printf(lcd_putc,"Ahoj...");
   delay_ms(1000);

//while(TRUE)
//{
//   read_nibble(&x);
//   lcd_gotoxy(1,1);                       // vytiskni X a Y
//   printf(lcd_putc,"O:%d    ",x);
//}

   x = 0;
   y = 0;
xc=0;
yc=0;

   while (true)
   {
   int8     osa, hodnota, kontrola;
   int      counter;                      // pocitadlo 1 a 0 v detektoru
   int      e1,e2;                        // pocitadla chyb - ladici
   
   e1=0;
   e2=0;
   
   counter=4;

decoder:

      counter=0;                                   // vynuluj citac
//      do                                           // vyhledej synchronizacni jednicky
//      {
//         if (!prijmout(&bit)) goto decoder;      // prijmi bit; pri chybe zacni znovu
//         if (1==bit) counter++; else goto decoder;  // kdyz je bit 1, tak zvys citac; jinak zacni znovu
//      } while(counter<4);                          // pockej na 4 jednicky
 if (!read_nibble(&osa)) goto decoder;
 if (osa!=15) {e1++; goto decoder;};
      if (!read_nibble(&osa)) goto decoder;   // nacti identifikator osy

      if (!read_nibble(&hodnota)) goto decoder;   // nacti 1. nibble; pri chybe zacni znovu
      if (!read_nibble(&kontrola)) goto decoder;  // nacti 2. nibble; pri chybe zacni znovu
      if (hodnota != kontrola) {e2++; goto decoder;}           // zacni znovu, pokud jsou ruzne nibble
      

      switch (osa)            // rozeskoc se podle adresy osy
      {
      case OSA_X:
         {
            x=hodnota;
            xc++;
            break;
         };
      case OSA_Y:
         {
            y=hodnota;
            yc++;
            break;
         };
      case TLs:
         {
            e1++;
            break;
         };
      };

      // ladici vypisy
      lcd_gotoxy(1,1);                       // vytiskni X a Y
      printf(lcd_putc,"X: %U %u %U     ", x, xc, e1);
      lcd_gotoxy(1,2);
      printf(lcd_putc,"Y: %U %U %U     ", y, yc, e2);

      // ovladani serv
      output_high(SERVO_X);
      delay_ms(1);
      for (osa=x; osa--; osa>0)
         delay_us(65);
      output_low(SERVO_X);

      output_high(SERVO_Y);
      delay_ms(1);
      for (osa=y; osa--; osa>0)
         delay_us(65);
      output_low(SERVO_Y);

      for (osa=30-x-y; osa--; osa>0)
         delay_us(65);

    }
}


