// Prijimac

#include "main.h"
#include "..\common.h"

#DEFINE  LCD_RS          PIN_B1      // rizeni registru LCD displeje
#DEFINE  LCD_E           PIN_B0      // enable LCD displeje
#DEFINE  LCD_DATA_LSB    PIN_B2      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"

#DEFINE  PRIJIMAC        PIN_A3      // pin na ktery je pripojen prijimac
#DEFINE  SERVO_X         PIN_A0      // pin na ktery je pripojeno servo
#DEFINE  SERVO_Y         PIN_A1


int8 prijmout(int8* bit)
{
// ||    |
// |--|_____   1
//       |
// |-|__|-|_   0

   while (!input(PRIJIMAC)) ;                // cekej na jednicku
   delay_us(IMPULS/4);                       // presvec se, jestli je stale 1 po 1/4 impulsu
   if (!input(PRIJIMAC)) return false;       // vrat chybu, kdyz neni stale 1
   delay_us(3*IMPULS);                       // pockej na rozhodovaci misto
///   if (input(PRIJIMAC)) *bit=0; else *bit=1; // dekoduj 1 nebo 0
   *bit=!input(PRIJIMAC);                    // dekoduj 1 nebo 0
   delay_us(IMPULS);                         // pockej na konec znaku

   return true;                                // vrat, ze se cteni povedlo
}

int8 read_nibble(int1* datovy, int8* data)
{
   int8 i;
   int8 d;
int1 tmp;

   d=0;

   // Cekam na dlouhou nulu
   for (i=4; i>0; i--)
   {
      if (input(PRIJIMAC)) i=4;
      delay_us(IMPULS/2);
   }

   // Cekam na jednicku (start ramce)
   for (; !input(PRIJIMAC); )
   {
      delay_us(IMPULS/8);
   }

//   delay_us(IMPULS/2);
   delay_us(2*IMPULS+IMPULS/2);
   *datovy=input(PRIJIMAC);

   // Prenasim bity
   for (i=0; i<4; i++)
   {
      delay_us(2*IMPULS);
      d >>= 1;
      if (input(PRIJIMAC)) d +=0b1000;
output_bit(PIN_A4,tmp);
tmp=!tmp;
   }
//   delay_us(2*IMPULS);           // cas posledniho datoveho bitu

   *data = d;
   return TRUE;
}


int8     x,y;
int8     xc,yc;          // pocitadla aktualizace x a y
int      e1,e2,e3,e4;    // pocitadla chyb - ladici

void main()
{
   lcd_init();                  // zinicializuj LCD display
   delay_ms(5);
   printf(lcd_putc,"Ahoj...");
   delay_ms(300);

   x = 0;
   y = 0;
   xc=0;
   yc=0;
   e1=0;
   e2=0;
   e3=0;
   e4=0;

   while (true)
   {
   int8     kanal, data, suma;
   int1 tmp;
   int8 datovy;

decoder:
//output_high(PIN_A1);

//      do                                           // vyhledej synchronizacni jednicky
//      {
//         if (!prijmout(&bit)) goto decoder;      // prijmi bit; pri chybe zacni znovu
//         if (1==bit) counter++; else goto decoder;  // kdyz je bit 1, tak zvys citac; jinak zacni znovu
//      } while(counter<4);                          // pockej na 4 jednicky
///output_bit(PIN_A1,tmp);
///tmp=!tmp;
 if (!read_nibble(&datovy,&kanal)) goto decoder;
 if (datovy) goto decoder;
// output_low(PIN_A1);
//output_low(PIN_A1);

// if (kanal!=15) {e1++; goto decoder;};
      if (!read_nibble(&datovy, &kanal)) goto decoder;   // nacti identifikator osy

      if (!read_nibble(&datovy, &data)) goto decoder;   // nacti 1. nibble; pri chybe zacni znovu
      if (!read_nibble(&datovy, &suma)) goto decoder;  // nacti 2. nibble; pri chybe zacni znovu
      if (((kanal+data) & 0b1111) != suma) {e1++; goto decoder;}           // zacni znovu, pokud jsou ruzne nibble


      switch (kanal)            // rozeskoc se podle adresy osy
      {
      case OSA_X:
         {
            x=data;
            xc++;
            break;
         };
      case OSA_Y:
         {
            y=data;
            yc++;
            break;
         };
      case TLs:
         {
            e4++;
            break;
         };
      };

      // ladici vypisy
      lcd_gotoxy(1,1);                       // vytiskni X a Y
      printf(lcd_putc,"X%2U %3U%3U%3U  ", x, xc, e1, e2);
      lcd_gotoxy(1,2);
      printf(lcd_putc,"Y%2U %3U%3U%3U  ", y, yc, e3, data);

      // ovladani serv
      output_high(SERVO_X);
      delay_ms(1);
      for (data=x; data--; data>0)
         delay_us(65);
      output_low(SERVO_X);

      output_high(SERVO_Y);
      delay_ms(1);
      for (data=y; data--; data>0)
         delay_us(65);
      output_low(SERVO_Y);

      for (data=30-x-y; data--; data>0)
         delay_us(65);

    }
}


