// Prijimac
#include "main.h"
#include "..\..\common.h"

#DEFINE  PRIJIMAC       PIN_A3      // pin na ktery je pripojen prijimac
#DEFINE  SERVO_X        PIN_A2      // piny na ktere jsou pripojena serva
#DEFINE  SERVO_Y        PIN_B0
#DEFINE  DILEK          20           // jeden krok serva v mikrosekundach

#bit  T0IF = 0xB.2   // int. flag od Timer0

static int8   x = 16;     // poloha serv
static int8   y = 16;
int8  trim_x = 2;
int8  trim_y = 2;

boolean flag;      // priznak, ze doslo k preruseni prijmu ovladanim serv

#int_TIMER0
TIMER0_isr()
{
   int8 n;

   flag = true;   // doslo k preruseni prijmu
//   x = 15;
//   y = 15;

   output_high(SERVO_X);   // uvodni impuls 1ms
   delay_ms(1);
   for (n=trim_x; n>0; n--);
   for (n=x; n>0; n--) Delay_us(DILEK);
   output_low(SERVO_X);

   output_high(SERVO_Y);
   delay_ms(1);
   for (n=trim_y; n>0; n--);
   for (n=y; n>0; n--) Delay_us(DILEK);
   output_low(SERVO_Y);
}

// output_high(PIN_B1);   // debug pin

void main()
{
   int i;
   int8 osa, data, check, suma;

   setup_counters(RTCC_INTERNAL,RTCC_DIV_64);   // Preruseni po 16,3ms
   enable_interrupts(INT_TIMER0);
   enable_interrupts(global);

loop:
   flag = false;

   // Cekej na uvodni ticho
   for (i=SYNC; i>0; i--)
   {
      delay_us(IMPULS/4);
      if (flag) goto loop;
      if (!input(PRIJIMAC)) i=SYNC;
   }

   // Cekej na startovaci 1
   while (input(PRIJIMAC)) if (flag) goto loop;

   if (flag) goto loop;

   // Posun na cteni prvniho datoveho bitu
   delay_us(2*IMPULS+2*IMPULS/3);

   // Cteme bity
   for (i=8; i>0; i--)
   {
      data <<= 1;
      if (input(PRIJIMAC)) data |= 1;
      if (flag) goto loop;
output_high(PIN_B1);   // debug pin
      delay_us(2*IMPULS+15);
output_low(PIN_B1);   // debug pin
   }

   // Cteme checksum
   check = 0;
   for (i=4; i>0; i--)
   {
      check <<= 1;
      if (input(PRIJIMAC)) check |= 1;
      if (flag) goto loop;
output_high(PIN_B1);   // debug pin
      delay_us(2*IMPULS+15);
output_low(PIN_B1);   // debug pin
   }

   swap(data);          // kontrola kontrolniho souctu
   suma = data & 0xF;   
   swap(data);
   suma += data & 0xF;
   suma++;
   suma &= 0xF;
   if (suma != check) goto loop;

   osa = data >> 5;  // extrahuj z ramce cislo osy a hodnotu
   data &= 0x1F;
   switch(osa)
   {
      case OSA_X:
         x=data;
        break;
      case OSA_y:
         y=data;
        break;
   }

   goto loop;
}
