// Prijimac

#DEFINE  DEBUG          PIN_A4      // ladici pomocne synchronizacni impulzy

#include "main.h"
#include "..\common.h"

#DEFINE  LCD_RS         PIN_B1      // rizeni registru LCD displeje
#DEFINE  LCD_E          PIN_B0      // enable LCD displeje
#DEFINE  LCD_DATA_LSB   PIN_B2      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"

#DEFINE  PRIJIMAC       PIN_A3      // pin na ktery je pripojen prijimac
#DEFINE  SERVO_X        PIN_A0      // pin na ktery je pripojeno servo
#DEFINE  SERVO_Y        PIN_A1

// Prijme datovy nibble vcetne zasynchronizovani
// Chybi dodelat timeout
int8 prijmi_nibble(int8* datovy, int8* data)
{
   int8 i;

   #IFDEF DEBUG
   int1 tmp;
   #ENDIF

   *data=0;

   // Cekam na dlouhou nulu
   for (i=4; i>0; i--)
   {
      if (input(PRIJIMAC)) i=4;
      delay_us(IMPULS/2);
   }

   // Cekam na jednicku (start ramce)
   for (; !input(PRIJIMAC); )
   {
   }

   // Ctu typ nibblu
   delay_us(2*IMPULS+2*IMPULS/3);
   *datovy=input(PRIJIMAC);

   // Prenasim bity
   for (i=0; i<4; i++)
   {
      delay_us(2*IMPULS);
      *data >>= 1;
      if (input(PRIJIMAC)) *data +=0b1000;

      #IFDEF DEBUG
      output_bit(DEBUG,tmp);
      tmp=!tmp;
      #ELSE
      delay_us(20);
      #ENDIF
   }

   return FALSE;
}


// Prijme datovy ramec
// Pokud nastane chyba vraci kod chyby
int8 prijmi_ramec(int8* kanal, int8* data)
{
   int8 datovy;
   int8 suma;

   // Cekej na synchronizacni nibble
   do
   {
      if (prijmi_nibble(&datovy, data)) return 1;     // chyba timout
   }
   while(datovy);

   // Zkontroluj magickou hodnotu
   if (*data != SYNC_NIBBLE) return 2;                // chyba magickeho kodu ramce

   // Prijmi cislo kanalu
   if (prijmi_nibble(&datovy, kanal)) return 1;      // chyba timeout
   if (!datovy) return 3;                             // chyba typu nibblu

   // Prijmi data
   if (prijmi_nibble(&datovy, data)) return 1;       // chyba timeout
   if (!datovy) return 3;                             // chyba typu nibblu

   // Prijmi zabezpeceni
   if (prijmi_nibble(&datovy, &suma)) return 1;       // chyba timeout
   if (!datovy) return 3;                             // chyba typu nibblu

   // Zkontroluj kontrolni soucet
   if (((*kanal+*data) & 0b1111) != suma) return 3;     // chyba kontrolniho souctu

   return 0;
}



int8     x,y,tlacitka;
int8     xc,yc;          // pocitadla aktualizace x a y
int      e1,e2,e3,e4;    // pocitadla chyb - ladici

void main()
{
   lcd_init();                  // zinicializuj LCD display
   delay_ms(5);
   printf(lcd_putc,"Ahoj...");
   delay_ms(300);

   x  = 0;
   y  = 0;
   xc = 0;
   yc = 0;
   e1 = 0;
   e2 = 0;
   e3 = 0;
   e4 = 0;

 while (true)
 {
   int8 kanal, data;

   if (prijmi_ramec(&kanal,&data))
   e1++;
   else
   {
      switch (kanal)            // rozeskoc se podle adresy osy
      {
      case OSA_X:
         {
            x=data;
            xc++;
            break;
         };
      case OSA_Y:
         {
            y=data;
            yc++;
            break;
         };
      case TLs:
         {
            tlacitka=data;
            break;
         };
      };
      
   if (true==bit_test(tlacitka,1))
   {
   output_high(pin_A2);
   
   }
   else output_low(pin_A2);
 

      // ladici vypisy
      
      lcd_gotoxy(1,1);                       // vytiskni X a Y
      printf(lcd_putc,"X%2U %3U%3U%3U  ", x, xc, e1, e2);
      lcd_gotoxy(1,2);
      printf(lcd_putc,"Y%2U %3U%3U%3U  ", y, yc, e3, tlacitka);

      // ovladani serv
      output_high(SERVO_X);
      delay_ms(1);
      for (data=x; data--; data>0)
         delay_us(65);
      output_low(SERVO_X);

      output_high(SERVO_Y);
      delay_ms(1);
      for (data=y; data--; data>0)
         delay_us(65);
      output_low(SERVO_Y);

      for (data=30-x-y; data--; data>0)
         delay_us(65);

    }
 }
}


