#include "main.h"
#include "..\common.h"

#DEFINE LCD_RS          PIN_B1      // rizeni registru LCD displeje
#DEFINE LCD_E           PIN_B0      // enable LCD displeje
#DEFINE LCD_DATA_LSB    PIN_B2      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"
#DEFINE PRIJIMAC        PIN_A3      // pin na ktery je pripojen prijimac
#DEFINE  SERVO_X         PIN_A0        // pin na ktery je pripojeno servo
#DEFINE  SERVO_Y         PIN_A1

int8     bit,x,y;
int      counter;                      // pocitadlo 1 a 0 v detektoru
int      x_old=0,y_old;

void servo(int uhel, int souradnice)
{
    
    
      if (X==souradnice) output_high(SERVO_X); else output_high(SERVO_Y);

      delay_us(62.5*uhel);

      if (SERVO_X==souradnice) output_low(SERVO_X); else output_low(SERVO_Y);
    //  delay_ms(10);
    
  
}

int8 prijmout(int8* bit)
{
// ||    |
// |--|_____   1
//       |
// |-|__|-|_   0

   while (!input(PRIJIMAC)) ;                // cekej na jednicku
   delay_us(IMPULS/4);                       // presvec se, jestli je stale 1 po 1/4 impulsu
   if (!input(PRIJIMAC)) return(false);          // vrat chybu, kdyz neni stale 1
   delay_us(3*IMPULS);                       // pockej na rozhodovaci misto
   if (input(PRIJIMAC)) *bit=0; else *bit=1; // dekoduj 1 nebo 0
   delay_us(IMPULS);                         // pockej na konec znaku

   output_bit(PIN_A0, *bit);  // kontrolni vystup

   return(true);                                // vrat, ze se cteni povedlo
}

int8 read_nibble(int8* value)
{
   int8 n;     // citac
   int8 bit;   // pomocna promenna

   *value=0;
   for (n=1; n<=4; n++)                      // prijmi 4 bity
   {
      *value >>= 1;                          // posun jiz prectene do leva
      if (0==prijmout(&bit)) return(false);      // prijmi bit; pri chybe cteni vrat chybu
      *value |= bit << 3;                    // pridej bit do nibblu
   };
   return(true);                                // vrat 1, jako ,ze je vse O.K.
}

/*void dekodovat(void)
{
   int8 osa, hodnota, kontrola;

   counter=4;

decoder:

      counter=0;                                   // vynuluj citac
      do                                           // vyhledej synchronizacni jednicky
      {
         if (!prijmout(&bit)) goto decoder;      // prijmi bit; pri chybe zacni znovu
         if (1==bit) counter++; else goto decoder;  // kdyz je bit 1, tak zvys citac; jinak zacni znovu
      } while(counter<4);                          // pockej na 4 jednicky

      if (!read_nibble(&osa)) goto decoder;   // nacti identifikator osy

      if (!read_nibble(&hodnota)) goto decoder;   // nacti 1. nibble; pri chybe zacni znovu
      if (!read_nibble(&kontrola)) goto decoder;  // nacti 2. nibble; pri chybe zacni znovu
      if (hodnota != kontrola) goto decoder;               // zacni znovu, pokud jsou ruzne nibble

      switch (osa)            // rozeskoc se podle adresy osy
      {
      case OSA_X:
         {
            x=hodnota;
            break;
         };
      case OSA_Y:
         {
            y=hodnota;
            break;
         };
      case TLs:
         {
            break;
         };
      };
}
*/
void main()
{
   lcd_init();                  // zinicializuj LCD display

   while (true)
   {
   int8 osa, hodnota, kontrola;

   counter=4;

decoder:

      servo(x_old,SERVO_X);
      
      servo(y_old,SERVO_Y);

      counter=0;                                   // vynuluj citac
      do                                           // vyhledej synchronizacni jednicky
      {
         if (!prijmout(&bit)) goto decoder;      // prijmi bit; pri chybe zacni znovu
         if (1==bit) counter++; else goto decoder;  // kdyz je bit 1, tak zvys citac; jinak zacni znovu
      } while(counter<4);                          // pockej na 4 jednicky

      if (!read_nibble(&osa)) goto decoder;   // nacti identifikator osy

      if (!read_nibble(&hodnota)) goto decoder;   // nacti 1. nibble; pri chybe zacni znovu
      if (!read_nibble(&kontrola)) goto decoder;  // nacti 2. nibble; pri chybe zacni znovu
      if (hodnota != kontrola) goto decoder;               // zacni znovu, pokud jsou ruzne nibble

      switch (osa)            // rozeskoc se podle adresy osy
      {
      case OSA_X:
         {
    
            x=hodnota;
            x_old=x;
            
            break;
         };
      case OSA_Y:
         {
            y=hodnota;
            y_old=y;
            
            break;
         };
      case TLs:
         {
            break;
         };
      };


      lcd_gotoxy(1,1);                       // vytiskni X a Y
      printf(lcd_putc,"X: %U      ", x);
      lcd_gotoxy(1,2);
      printf(lcd_putc,"Y: %U      ", y);
    }
}


